#include "(CurrentProject)/vTools/properties.js"
#include "(CurrentProject)/vTools/utils.js"

importClass("VDir");
importClass("VTextFile");
importClass("VFile");
importClass("VProcess");


Date.prototype.fromString = function(str, datetime) {
    var m = str.match(/(\d+)(\/)(\d+)(\/)(\d+)(\s+(\d+):(\d+)(?::(\d+))?(?:\.(\d+))?)?/);
	if (m) {
		if (datetime)
			return new Date(m[5], m[3] - 1, m[1], m[7], m[8], (m[9]?m[9]:0), 0)
		else
			return new Date(m[5], m[3]-1, m[1]);
	}
	else
		return null;
}

Date.prototype.yyyymmdd = function() {
	var yyyy = this.getFullYear().toString();
	var mm = (this.getMonth()+1).toString(); // getMonth() is zero-based
	var dd  = this.getDate().toString();
	return yyyy + "/" + (mm[1]?mm:"0"+mm[0]) + "/" + (dd[1]?dd:"0"+dd[0]); // padding
};

Date.prototype.yyyymmddhhmmss = function() {
	var yyyy = this.getFullYear().toString();
	var mm = (this.getMonth()+1).toString(); // getMonth() is zero-based
	var dd  = this.getDate().toString();
	var hh = this.getHours().toString();
	var min = this.getMinutes().toString();
	var ss = this.getSeconds().toString();
	return yyyy + "/" + (mm[1]?mm:"0"+mm[0]) + "/" + (dd[1]?dd:"0"+dd[0]) + " " + hh + ":" + min + ":" + ss; // padding
};
  
// -------------------------------------------------------------------------------------------------------
// Exportar contenido de una rejilla a Excel utilizando Visual Basic Script (Sólo para Windows)
// -------------------------------------------------------------------------------------------------------
// Obtenemos la rejilla activa
var rejilla = getActiveListControl();
if (rejilla!=null) {
	// Obtenemos la información de la rejilla
	var rejillaInfo = rejilla.objectInfo();
	// Solo se exporta si es una rejilla
	if (rejillaInfo.type() == VObjectInfo.TypeGrid) {
		try {
			// TODO: Comprobar que estamos en Windows
			theApp.setOverrideCursor(VApp.WaitCursor);
			decimalPoint = theApp.currentDecimalPoint();
			var filas = this.rejilla.listSize();
			var columnas = this.rejilla.columnCount();
			
			// Preparar scriptVB a procesar
			var scriptVB = 'On Error Resume Next' + '\r\n';
			scriptVB += 'Const xlNormal = -4143'  + '\r\n'
			scriptVB += 'set wss=createobject("wscript.shell")'  + '\r\n'
			scriptVB += 'set objExcel = CreateObject(' + '"' + 'Excel.Application' + '"' + ')' + '\r\n';
			scriptVB += 'if Err.Number <> 0 then' + '\r\n';
			scriptVB += 'Wscript.Echo "Excel application not installed."' + '\r\n';
			scriptVB += 'Wscript.Quit' + '\r\n';
			scriptVB += 'end if' + '\r\n';
			scriptVB += 'On Error GoTo 0' + '\r\n';
			// Con esta instrucción conseguimos que el excel no se vea mientras se carga de datos
			scriptVB += 'objExcel.Visible = False' + '\r\n';
			scriptVB += 'objExcel.Workbooks.Add' + '\r\n';
			scriptVB += 'objExcel.WindowState = xlNormal' + '\r\n';
			scriptVB += 'Set objSheet = objExcel.ActiveWorkbook.Worksheets(1)' + '\r\n';
			scriptVB += 'objSheet.Name = "' + rejillaInfo.name() + '"' + '\r\n';
			var fila = 1;
			var ocultas = 0;
			try {
				for ( var columna = 0; columna < columnas; columna++ ) {
					if (this.rejilla.isColumnHidden(columna))
						ocultas++
					else {
						if (this.rejilla.dataType(columna) != VGridListDataView.TypeImage) {
							var columnaInfo = this.rejillaInfo.subObjectInfo( VObjectInfo.TypeGridCol, columna );
							// Preparar títulos de cabecera de las columnas
							scriptVB += 'objSheet.Cells(' + fila + ',' + (columna+1-ocultas) + ').Value =' + '"' + columnaInfo.name() + '"' + '\r\n';
						}
					}
				}
				try {
					// Iniciamos la barra de progreso
					theRoot.initProgressBar();
					// TODO: Pasar a constante
					theRoot.setTitle("Exportando " + filas + " elemento(s)");
					for (fila = 0; fila < filas; fila++) {
						ocultas = 0;
						for (var columna = 0; columna < columnas; columna++) {
							if (this.rejilla.isColumnHidden(columna))
								ocultas++
							else {
								if (this.rejilla.dataType(columna) != VGridListDataView.TypeImage) {
									dato = this.rejilla.data(fila, columna);
									// Sustituimos las comillas dobles por simples
									dato = dato.replace(/"/g, "'");
									// Sustituimos los retornos de carro por chr(10)
									dato = dato.replace(/\r\n/g, '"+chr(10)+"');
									dato = dato.replace(/\n/g, '"+chr(10)+"');
									// Si es fecha le asignamos el formato fecha
									if ((this.rejilla.dataType(columna) == VGridListDataView.TypeDate)) {
										fecha = (new Date()).fromString(dato, false);
										if (fecha) 
											scriptVB += 'objSheet.Cells(' + (fila+2) + ',' + (columna+1-ocultas) + ').Value="'+fecha.yyyymmdd()+'"\r\n'
										else
											scriptVB += 'objSheet.Cells(' + (fila+2) + ',' + (columna+1-ocultas) + ').Value=chr(39)+"'+dato+'"\r\n';
									} else if ((this.rejilla.dataType(columna) == VGridListDataView.TypeDateTime)) {
										fecha = (new Date()).fromString(dato, true);
										if (fecha)
											scriptVB += 'objSheet.Cells(' + (fila+2) + ',' + (columna+1-ocultas) + ').Value="'+fecha.yyyymmddhhmmss()+'"\r\n'
										else
											scriptVB += 'objSheet.Cells(' + (fila+2) + ',' + (columna+1-ocultas) + ').Value=chr(39)+"'+dato+'"\r\n';
									} else if (this.rejilla.dataType(columna) == VGridListDataView.TypeNumber) {
										var datoEnPartes = dato.split(".");
										var numeroDecimales = 0;
										if (datoEnPartes.length>1) {
											numeroDecimales = datoEnPartes[1].length;
										}
										if (numeroDecimales>0) {
											scriptVB += 'objSheet.Cells(' + (fila+2) + ',' + (columna+1-ocultas) + ').NumberFormat =' + '"0.0'+Array(numeroDecimales).join("#")+'"' + '\r\n';
										}
										scriptVB += 'objSheet.Cells(' + (fila+2) + ',' + (columna+1-ocultas) + ').Value = "' + dato + '"\r\n';
									} else {
										// Le sumamos 2 a la fila porque en excel las filas empiezan en 1 y en la posición 1 están los títulos
										scriptVB += 'objSheet.Cells(' + (fila+2) + ',' + (columna+1-ocultas) + ').Value =chr(39)+"' + dato + '"\r\n';
									}
								}
							}
						}
						theRoot.setProgress(fila*100/filas);						
					}
				} finally {
					theRoot.endProgressBar();
				}
			} catch(err) {
				alert(err);
				return false;
			}
			// Con esta instrucción hacemos visible el excel
			scriptVB += 'objExcel.Visible = True' + '\r\n';
			// Guardamos el fichero vbs y lo ejecutamos
			var ficheroScrtipVB = new VTextFile(theRoot.clientCachePath() + "ExcelScript.vbs");
	 
			// Se abre el fichero en modo escritura, crea si no existe o limpia si existe
			if ( ficheroScrtipVB.open(VFile.OpenModeWriteOnly | VFile.OpenModeTruncate)) {
				// Se guarda el script generado
				ficheroScrtipVB.write(scriptVB);
				// Se cierra el fichero
				ficheroScrtipVB.close();
			}
			// Preguntar si queremos abrir el fichero xls creado
			var proceso = new VProcess(theRoot);
			proceso.setProcess("vTools/LAUNCH_COMMAND");
			// Le pasamos el comando que tiene que lanzar
			proceso.setVar("CMD", theRoot.clientCachePath() + "ExcelScript.vbs");
			proceso.exec();
		} finally {
			theApp.restoreOverrideCursor();
		}
	} else
		alert("Esta funcionalidad es válida sólo para rejillas.");
} else 
	alert("Esta funcionalidad es válida sólo para rejillas.");
