function getOS() {
  var userAgent = window.navigator.userAgent,
      platform = window.navigator.platform,
      macosPlatforms = ['Macintosh', 'MacIntel', 'MacPPC', 'Mac68K'],
      windowsPlatforms = ['Win32', 'Win64', 'Windows', 'WinCE'],
      iosPlatforms = ['iPhone', 'iPad', 'iPod'],
      os = null;

  if (macosPlatforms.indexOf(platform) !== -1) {
    os = 'Mac OS';
  } else if (iosPlatforms.indexOf(platform) !== -1) {
    os = 'iOS';
  } else if (windowsPlatforms.indexOf(platform) !== -1) {
    os = 'Windows';
  } else if (/Android/.test(userAgent)) {
    os = 'Android';
  } else if (!os && /Linux/.test(platform)) {
    os = 'Linux';
  }

  return os;
}


playable.init = function () {
  playable.GAME_NAME = 'name_advertiser-name_game';
  playable.REWARDED_DURATION = '30';
  playable.INTERSTITIAL_DURATION = '15';
  playable.HIDE_TIMER = 'true';
};

playable.ready = function () {
    document.getElementById('game-inner').style['visibility'] = 'visible';
};

playable.size = function () {
	
    var height = document.getElementById('game').offsetHeight;
    var width = document.getElementById('game').offsetWidth;
    var size = width;

    if(width > height) {
        RATIO = width / height;
    }
    else {
        RATIO = height / width;
    }
    
    if (height < width) {
        size = height;
    }

    //console.log("**** PLAYABLE SCREEN: " + width + "," + height);
    //console.log("**** PLAYABLE PIXEL RATIO: " + window.devicePixelRatio);
    
    return size; // (size) * window.devicePixelRatio;
};

playable.scale = function () {

    var height = document.getElementById('game').offsetHeight;
    var width = document.getElementById('game').offsetWidth;
    var size = width;

    if(width > height) {
        RATIO = width / height;
    }
    else {
        RATIO = height / width;
    }    
    
    const ratio = window.innerWidth / window.innerHeight;

    isX = false;
    
    if (ratio < 0.65) 
    {
        isIPAD = false;
        if(ratio < 0.5) {
            isX = true;
        }
        else {
            isX = false;
        }        
    } 
    else if (ratio < 1) 
    {
        isIPAD = true;
    } 
    else if (ratio < 1.5555) 
    {
        isIPAD = true;
    } 
    else 
    {
        if(ratio > 2) {
            isX = true;
        }
        else {
            isX = false;
        }
        isIPAD = false;
    }
    
    return (playable.size() / OS_WORK_SCREEN_WIDTH) * 1.0;
};
