/*
    author: Stefano Campodall'Orto
    copyright by Smallthing Studio 2018-2019 all right reserved.
*/
var Smallthing = Smallthing || {};

Smallthing.SceneGame = function(callbackIntro, callbackIntroThis) {
    
    SCENEGAME = this;

    getManager3D().envmap = new THREE.CubeTextureLoader().load( [ PRELOAD.get('px'), 
                                                                  PRELOAD.get('nx'), 
                                                                  PRELOAD.get('py'), 
                                                                  PRELOAD.get('ny'), 
                                                                  PRELOAD.get('pz'), 
                                                                  PRELOAD.get('nz') ] 
                                                                );

    getManager3D().importApp('app', function(){

        var lightShadow = getManager3D().getObjectByName('PointLight');
        if(lightShadow != null)
        {
            lightShadow.castShadow = true;
        }
/*
        //Create a PointLight and turn on shadows for the light
        var light = new THREE.PointLight( 0xffffff, 1, 0 );
        light.position.set( 0, 10, 2 );
        light.castShadow = true;            // default false
        light.intensity = 0;
        getManager3D().current_scene.add( light );

        //Set up shadow properties for the light
        light.shadow.mapSize.width = 2048;  // default
        light.shadow.mapSize.height = 2048; // default
        light.shadow.camera.near = 0.1;       // default
        light.shadow.camera.far = 1000      // default
*/
        this.city = new Smallthing.Env(function(){

            this.car1 = new Smallthing.Car('Car', function(object){

                object.setPosition(OBJECTMANAGER.getObjectByName('_loc_car1_').position);
                object.body = object.getObjectByName('Lamborghini_Aventador:Body.001');
                if(object.body != null) {

                    object.body.material.color.r = 1.0;
                    object.body.material.color.g = 1.0;
                    object.body.material.color.b = 1.0;            
                    object.body.material.specular.r = 1.0;
                    object.body.material.specular.g = 1.0;
                    object.body.material.specular.b = 1.0;
                }

                this.car2 = new Smallthing.Car('Car', function(object){

                    object.setPosition(OBJECTMANAGER.getObjectByName('_loc_car2_').position);
                    object.body = object.getObjectByName('Lamborghini_Aventador:Body.001');
                    if(object.body != null) {

                        object.body.material.color.r = 1.0;
                        object.body.material.color.g = .0;
                        object.body.material.color.b = .0;     
                        object.body.material.specular.r = 1.0;
                        object.body.material.specular.g = 1.0;
                        object.body.material.specular.b = 1.0;                               
                    }
                    
                    this.isReady = true;

                }, this);
            
            }, this);
            
        }, this);


        getManager3D().setBackgroundColor(0,0,0);
        //getManager3D().setFog(1, 8);

        this.camera = getManager3D().current_camera;        

        var light1 = new THREE.PointLight( 0xffffff, 1, 3 );
        light1.position.set( 0, 1, 10 );
        Common3D_set(light1);
        getManager3D().add( light1 ); 

        //light1.visible = false;

        var light2 = new THREE.PointLight( 0xffffff, 1, 3 );
        light2.position.set( 0, 1, 10 );
        Common3D_set(light2);
        getManager3D().add( light2 ); 
        //light2.visible = false;

        var light3 = new THREE.PointLight( 0xffffff, 1, 3 );
        light3.position.set( 0, 1, 10 );
        Common3D_set(light3);
        getManager3D().add( light3 ); 
        //light3.visible = false;

        this.lighters = [
            light1,light2,light3
        ];

        this.lightersIndex = 0;

        //
        getManager3D().addComposers(getManager3D().current_scene, getManager3D().current_camera);
        getManager3D().addBloom();
        getManager3D().__resize();

    }, this);

    this.isEnable = false;
}

Smallthing.SceneGame.prototype.constructor = Smallthing.SceneGame;

Smallthing.SceneGame.prototype.destroy = function(callback, callbackThis)
{
}

Smallthing.SceneGame.prototype.createMoveLight = function()
{
    var index = this.lightersIndex % 3;
    this.lightersIndex++;
    var light = this.lighters[index];
    //light.visible = true;
    //this.light.color = 0xAAAAAA;
    light.createTweenAnimPosition(false, {x:0, y:0, z:0}).to({z:-20}, 1000-this.car1.velocity*0.5).call(function(){
        //this.visible = false;
        //this.color = 0;
    }, null, light);    
}   
    


Smallthing.SceneGame.prototype.createWindLine = function(){

    var material = new THREE.LineDashedMaterial( {
        color: 0xffffff,
        linewidth: rndInt(1,6),
        scale: rndInt(3,10),
        dashSize: 3,
        gapSize: 1,
    } );

    var geometry = new THREE.Geometry();
    var x = rndInt(-100, 100)/100;
    var y = rndInt(10, 50)/100;
    geometry.vertices.push(new THREE.Vector3( x, y, 3) );
    geometry.vertices.push(new THREE.Vector3( x, y, 2.5) );
    var line = new THREE.Line( geometry, material );
    getManager3D().current_scene.add( line );
    Common3D_set(line);
    line.createTweenAnimPosition().to({z:-3}, rndInt(500, 800)).call(function(){

        getManager3D().current_scene.remove(this);

        //this.geometry.dispose();
        //this.material.dispose();
    }, null, line);
}

Smallthing.SceneGame.prototype.start = function()
{
    if(this.city != null)
        this.city.start();

    if(this.car1 != null)
        this.car1.start(function(){

        }, this);

    if(this.car2 != null)
        this.car2.start(function(){

        }, this);

    this.timeToMoveForward = rndInt(0, 10)/10;

    if(this.car1 != null)
        this.car1.moveTo(rndInt(30, 100), rndInt(2000, 3000), function(){
            
        }, this);
    
    if(this.car2 != null)
        this.car2.moveTo(rndInt(30, 100), rndInt(2000, 3000), function(){

        }, this);

    this.limitCameraXmin = this.camera.position.x;
    this.limitCameraYmin = this.camera.position.y;
    this.limitCameraXmax = this.camera.position.x-.1;
    this.limitCameraYmax = this.camera.position.y+.1;

    GAME.Tween.get(this.camera.position).to({x:this.camera.position.x-.3, z:this.camera.position.y+.3}, 10000, GAME.Ease.cubicInOut).call(function(){
        this.timeToMoveCamera = rndInt(5,10)/10.0;
    }, null, this);

    this.timeToLine = 2.0;
    this.timeToMoveLight = 2.0;
    this.kTimeToMoveLight = 1.0;

    createTimeEvent(4000, function(){
        this.kTimeToMoveLight = 0.5;
    }, this);

    getManager3D().addMotionBlur();  
}

Smallthing.SceneGame.prototype.onUpdate = function(dtime)
{    
    if(!this.isEnable)
    {
        if(this.isReady)
        {
            this.isEnable = true;

            playMusic('CarEngineStart');

            createTimeEvent(3000, function(){
                this.start();
            }, this);
        }

        return;
    }

    if(this.timeToMoveForward >= 0 && this.car1 != null && this.car2 != null) {

        this.timeToMoveForward -= dtime;
        if(this.timeToMoveForward < 0)
        {
            this.timeToMoveForward = rndInt(10, 20)/10; 

            this.car1.moveTo(rndInt(30, 100), rndInt(2000, 3000), function(){
                
            }, this);
            
            this.car2.moveTo(rndInt(30, 100), rndInt(2000, 3000), function(){

            }, this);
        }
    }

    if(this.timeToMoveCamera != null && this.timeToMoveCamera > 0)
    {
        this.timeToMoveCamera -= dtime;
        if(this.timeToMoveCamera < 0)
        {
            var x = rndInt(this.limitCameraXmin, this.limitCameraXmax);
            var y = rndInt(this.limitCameraYmin, this.limitCameraYmax);

            GAME.Tween.get(this.camera.position).to({x:x, z:y}, rndInt(3000,5000), GAME.Ease.cubicInOut).call(function(){
                this.timeToMoveCamera = rndInt(5,10)/10.0;
            }, null, this);
        }
    }

    if(this.timeToLine != null && this.timeToLine >= 0)
    {
        this.timeToLine -= dtime;
        if(this.timeToLine < 0)
        {
            this.timeToLine = rndInt(1, 10)/10;
            for(var i = 0; i < rndInt(2, 5); i++)
                this.createWindLine();
        }
    }

    if(this.timeToMoveLight != null && this.timeToMoveLight >= 0)
    {
        this.timeToMoveLight -= dtime;
        if(this.timeToMoveLight < 0)
        {
            this.timeToMoveLight = 2.0 * this.kTimeToMoveLight;
            this.createMoveLight();
        }
    }

    if(OS_SCREEN_TYPE == OS_SCREEN_TYPE_LANDSCAPE)
    {
        
    }
    else {
    
    }    
}