var Smallthing = Smallthing || {};

BLACKSCREEN = null;

Smallthing.GameManager = function(game) {

    Scene_set(this);

    GAME_LAYER_BACKGROUND =         new createjs.Container();
    GAME_LAYER_DEFAULT =            new createjs.Container();
    GAME_LAYER_GAME =               new createjs.Container();
    GAME_LAYER_GAME_COLLISIONBOX =  new createjs.Container();
    GAME_LAYER_START_BACKGROUND =   new createjs.Container();
    GAME_LAYER_START_PARTICLES =    new createjs.Container();
    GAME_LAYER_START =              new createjs.Container();
    GAME_LAYER_START_OVER =         new createjs.Container();
    GAME_LAYER_UI =                 new createjs.Container();
    GAME_LAYER_UI_BACK =            new createjs.Container();
    GAME_LAYER_END0 =               new createjs.Container();
    GAME_LAYER_END1 =               new createjs.Container();
    GAME_LAYER_END1_GAME =          new createjs.Container();
    GAME_LAYER_END1_BACKGROUND =    new createjs.Container();
    GAME_LAYER_END1_FOREGROUND =    new createjs.Container();
    GAME_LAYER_END2_BACKGROUND =    new createjs.Container();
    GAME_LAYER_END2 =               new createjs.Container();
    GAME_LAYER_END2_FOREGROUND =    new createjs.Container();
    GAME_LAYER_END2_ELEMENTS =       new createjs.Container();
    GAME_LAYER_FOREGROUND =         new createjs.Container();
    GAME_LAYER_BLACKSCREEN =         new createjs.Container();
    
    STAGE.addChild(GAME_LAYER_BACKGROUND);
    STAGE.addChild(GAME_LAYER_DEFAULT);
    STAGE.addChild(GAME_LAYER_GAME);
    STAGE.addChild(GAME_LAYER_GAME_COLLISIONBOX);
    STAGE.addChild(GAME_LAYER_UI_BACK);
	STAGE.addChild(GAME_LAYER_UI); 
    STAGE.addChild(GAME_LAYER_START_BACKGROUND);
    STAGE.addChild(GAME_LAYER_START_PARTICLES);
    STAGE.addChild(GAME_LAYER_START);
    STAGE.addChild(GAME_LAYER_START_OVER);
    STAGE.addChild(GAME_LAYER_END0);
    STAGE.addChild(GAME_LAYER_END1_BACKGROUND);
    STAGE.addChild(GAME_LAYER_END1);
    STAGE.addChild(GAME_LAYER_END1_GAME);
    STAGE.addChild(GAME_LAYER_END1_FOREGROUND);
    STAGE.addChild(GAME_LAYER_END2_BACKGROUND);
    STAGE.addChild(GAME_LAYER_END2);
    STAGE.addChild(GAME_LAYER_END2_FOREGROUND);
    STAGE.addChild(GAME_LAYER_END2_ELEMENTS);
    STAGE.addChild(GAME_LAYER_FOREGROUND);
    STAGE.addChild(GAME_LAYER_BLACKSCREEN);
    
    setOffset = function(x, y) {

        var ox = x;
        var oy = y;

        if(x.x != null)
        {
            ox = x.x;
            oy = x.y;            
        }        

        if(this.offset == null)
        {
            this.offset = {x:0, y:0};
        }

        this.offset.x = ox;
        this.offset.y = oy;
    }

    setScale = function(x, y) {
        var sx = x;
        var sy = y;

        if(this.offset == null)
        {
            this.offset = {x:0, y:0};
        }


        if(x.x != null)
        {
            sx = x.x;
            sy = x.y;            
        }        

        this.regX = STAGE.canvas.width * 0.5;
        this.regY = STAGE.canvas.height * 0.5;
        this.x = (STAGE.canvas.width * 0.5)+this.offset.x;
        this.y = (STAGE.canvas.height * 0.5)+this.offset.y;
        this.scaleX = sx;
        this.scaleY = sy;        
    }

    for(var i in STAGE.children)
    {
        var child = STAGE.children[i];
        child.setScale = setScale;
        child.setOffset = setOffset;
    }

    g = GAME;

    GAMEMANAGER = this;
    SCENEGAME = null;
    
    this.particles = new Array();
    
    this.init();    
};

Smallthing.GameManager.prototype.constructor = Smallthing.GameManager;

Smallthing.GameManager.prototype.init = function(gameState)
{    
    this.start();
}

Smallthing.GameManager.prototype.start = function()
{
    if(Smallthing.SceneGame != null)
        this.sceneGame = new Smallthing.SceneGame(function(){
                            
        }, this);
    else
        console.log("!!We suggest to create a sceneGame class!!");

    createTimeEvent(250, function(){

        // tap to try enable after 1 second more or less
        
        this.sceneStart = new Smallthing.SceneStart();

    }, this);

    // this.gameOver();
};

Smallthing.GameManager.prototype.firstInteraction = function()
{
    if(this.firstInteraction_done != null) {

        return ;
    }
    
    this.firstInteraction_done = true;

    GAMEMANAGER.gameStarted = true;
    
    this.sceneGame.start();
    
    if(typeof SCENESTART !== 'undefined')
        SCENESTART.firstInteraction();
    this.sceneStart = null;

}

Smallthing.GameManager.prototype.gameOver = function()
{
    if(this.isGameOver)
        return;

    this.isGameOver = true;

}

Smallthing.GameManager.prototype.onUpdate = function(dtime)
{
    if(this.particles != null)
    {
        for(var i = this.particles.length-1; i >= 0; i--)
        {
            var p = this.particles[i];
            p.onUpdate(dtime);
            if(p.done)
            {
                p.destroy();
                this.particles.splice(i, 1);
            }
        }
    }

    if(this.sceneStart != null)
        this.sceneStart.onUpdate(dtime);

    if(this.sceneGame != null)
        this.sceneGame.onUpdate(dtime);
}
