Smallthing = Smallthing || {}

Smallthing.Env = function(c, cs)
{
    this.c = c;
    this.cs = cs;
    this.models = [];

    this.isReady = false;
    this.speed = 0;
    this.position = new THREE.Vector3();

    AUTOUPDATE.push(this);

    this.cacheA = [];
    this.cacheA_index = 0;
    this.cacheB = [];
    this.cacheB_index = 0;
    this.cacheCount = 8;
    this.distance_between_blocks = 8.0;

    this.getModelA = function()
    {
        var ret = this.cacheA[this.cacheA_index++ % this.cacheCount];
        return ret;
    }

    this.getModelB = function()
    {
        var ret = this.cacheB[this.cacheB_index++ % this.cacheCount];
        return ret;
    }

    getManager3D().import('CityA', function(object){

        this.isReadyA = true;

        object.setRotation(0,180,0);
        //object.enableReceiveShadow(); 
        // var street = object.getObjectByName('Street_Plane');
        // if(street != null)
        //     street.enableReceiveShadow();

        getManager3D().current_scene.remove(object);

        // create cache
        var o = null;
        for(var j = 0; j < this.cacheCount; j++) {
            o = object.clone(); Common3D_set(o); this.cacheA.push(o);
            o.setRotation(0,180,0);
            //o.enableReceiveShadow(); 
            var street = o.getObjectByName('Street_Plane');
            if(street != null)
                street.enableReceiveShadow();                        
        }

    }, this, null, true);    

    getManager3D().import('CityB', function(object){

        this.isReadyB = true;

        object.setRotation(0,180,0);
        //object.enableReceiveShadow(); 
        // var street = object.getObjectByName('Street_Plane');
        // if(street != null)
        //     street.enableReceiveShadow();

        getManager3D().current_scene.remove(object);            

        var o = null;
        for(var j = 0; j < this.cacheCount; j++) {
            o = object.clone(); Common3D_set(o); this.cacheB.push(o);
            o.setRotation(0,180,0);
            var street = o.getObjectByName('Street_Plane');
            if(street != null)
                street.enableReceiveShadow();                        
            //o.enableReceiveShadow(); 
        }

    }, this, null, true); 

};

Smallthing.Env.prototype.composeStreet = function()
{
    var o = this.getModelA();
    o._position.z = -this.distance_between_blocks;
    getManager3D().current_scene.add(o);
    this.models.push(o);

    o = this.getModelA();
    getManager3D().current_scene.add(o);
    this.models.push(o);

    o = this.getModelB();
    getManager3D().current_scene.add(o);
    this.models.push(o);

    this.updatePosition(0);
}

Smallthing.Env.prototype.createNode = function()
{
    var o = null;

    if(rndInt(0,100) > 50)
    {
        o = this.getModelA();
    }
    else {
        o = this.getModelB();
    }

    getManager3D().current_scene.add(o);

    this.models.push(o);

    for(var i = 1; i < this.models.length; i++) {

        this.models[i]._position.z = this.models[i-1]._position.z + this.distance_between_blocks;
    }

    return;
};

Smallthing.Env.prototype.destroy = function()
{

};

Smallthing.Env.prototype.start = function()
{
    this.isEnable = true;
    GAME.Tween.get(this).to({speed:10}, 3000, GAME.Ease.In);
};

Smallthing.Env.prototype.turbo = function()
{
    GAME.Tween.get(this).to({speed:20}, 1000, GAME.Ease.In);
}

Smallthing.Env.prototype.setPosition = function(position)
{
    if(!this.isReady)
        return;

    this.position.x = position.x;
    this.position.y = position.y;
    this.position.z = position.z;
};

Smallthing.Env.prototype.updatePosition = function(dtime)
{
    if(this.position != null && this.models.length > 0) {

        var d  = this.speed * dtime;
        var first = this.models[0];
        var last = this.models[this.models.length-1];
        

        if(last._position.z < -.2 + this.distance_between_blocks)
        {
            this.createNode();
        }

        first._position.z -= d;
        if(first._position.z < -this.distance_between_blocks*3.0)
        {
            getManager3D().current_scene.remove(first);
            this.models.splice(0,1);
        }

        for(var i = 1; i < this.models.length; i++) {

            this.models[i]._position.z = this.models[i-1]._position.z + this.distance_between_blocks;
        }
    }    
}

Smallthing.Env.prototype.onUpdate = function(dtime)
{
    if(this.isReadyA && this.isReadyB)
    {
        if(!this.isReady) {
            this.composeStreet();
            this.isReady = true;
            GAME.Tween.get(this).call(this.c, null, this.cs);
        }
    }

    if(!this.isEnable)
        return;

    this.updatePosition(dtime);
};
