Smallthing = Smallthing || {}


Smallthing.Car = function(file, c, cs)
{
    this.velocity = 0;
    this.speed = 100;
    this.max_speed = 1000;

    this.angle = 0;

    this.c = c;
    this.cs = cs;

    this.kMult = 200.0;

    if(file.name != null)
    {
        Common3D_set(file);
        // cloned because is a mesh
        this.set(file);
    }
    else {

        getManager3D().import(file, function(obj){

            this.set(obj);

        }, this);
    }

    AUTOUPDATE.push(this);

    this.isEnable = false;
    this.isReady = false;
    this.isMove = false;
};

Smallthing.Car.prototype.clone = function()
{
    return this.car.clone();
}

Smallthing.Car.prototype.set = function(obj)
{
    this.car = obj;


    //obj.createTweenAnimAngle({loop:true}).to({y:360},10000);
    this.car.Body = obj.getObjectByName('Lamborghini_Aventador:Body.001');
    this.car.Body.material.shininess = 40;
    this.car.Body.material.envMap = getManager3D().envmap;
    this.car.Body.material.reflectivity = 0.5;
    this.car.Body.enableShadowCast();

/*
    var light = getManager3D().getObjectByName('PointLight');
    if(light != null) {
        getManager3D().createShadowMesh(this.car.Body, light);
    }
*/  
    this.car.Glass = obj.getObjectByName('Lamborghini_Aventador:Glass.001');
    this.car.Glass.enableOpacity();
    this.car.Glass.alpha = 0.8;
    this.car.Wheel_FL = obj.getObjectByName('Cube2_Cube.001');
    this.car.Wheel_FR = obj.getObjectByName('Cube1_Cube');
    this.car.Wheel_RL = obj.getObjectByName('Cube3_Cube.002');
    this.car.Wheel_RR = obj.getObjectByName('Cube4_Cube.003');

    
    this.LightRight = new THREE.SpotLight( 0xffffff );
    this.LightRight.position.set( 100, 1000, 100 );
    this.LightRight.intensity = 5.0;
    this.LightRight.angle = 0.3;
    this.LightRight.penumbra = 1.0;
    this.LightRight.decay = 2.0;
    this.LightRight.position.set(0.14,0.11,0.4);
    this.LightRight.target.position.set(0.14,0,2.0);
    this.LightRight.distance = 1.42;

    // ADD SPOTLIGHT
    this.car.add(this.LightRight);
    this.car.add(this.LightRight.target);

    this.LightLeft = new THREE.SpotLight( 0xffffff );
    this.LightLeft.position.set( 100, 1000, 100 );
    this.LightLeft.intensity = 5.0;
    this.LightLeft.angle = 0.3;
    this.LightLeft.penumbra = 1.0;
    this.LightLeft.decay = 2.0;
    this.LightLeft.position.set(-0.14,0.11,0.4);
    this.LightLeft.target.position.set(-0.14,0,2.0);
    this.LightLeft.distance = 1.42;

    // ADD SPOTLIGHT
    this.car.add(this.LightLeft);
    this.car.add(this.LightLeft.target);

    getManager3D().import('Wheel', function(obj){

        // FR
        if(!this.car.Wheel_FR.geometry.boundingSphere)
            this.car.Wheel_FR.geometry.computeBoundingSphere();
        var posFR = this.car.Wheel_FR.geometry.boundingSphere.center;
        this.car.Wheel_FR.setVisible(false);
        this.Wheel_FR = obj.clone();
        Common3D_set(this.Wheel_FR);
        this.Wheel_FR.enableShadowCast();
        this.car.add(this.Wheel_FR);
        this.Wheel_FR.setPosition(posFR);

        // FL
        if(!this.car.Wheel_FL.geometry.boundingSphere)
            this.car.Wheel_FL.geometry.computeBoundingSphere();        
        var posFL = this.car.Wheel_FL.geometry.boundingSphere.center;
        this.car.Wheel_FL.setVisible(false);
        this.Wheel_FL = obj.clone();
        Common3D_set(this.Wheel_FL);
        this.Wheel_FL.enableShadowCast();
        this.car.add(this.Wheel_FL);
        this.Wheel_FL.setPosition(posFL);

        if(!this.car.Wheel_RR.geometry.boundingSphere)
            this.car.Wheel_RR.geometry.computeBoundingSphere();        
        var posRR = this.car.Wheel_RR.geometry.boundingSphere.center;
        this.car.Wheel_RR.setVisible(false);
        this.Wheel_RR = obj.clone();
        Common3D_set(this.Wheel_RR);
        this.Wheel_RR.enableShadowCast();
        this.car.add(this.Wheel_RR);
        this.Wheel_RR.setPosition(posRR);

        if(!this.car.Wheel_RL.geometry.boundingSphere)
            this.car.Wheel_RL.geometry.computeBoundingSphere();        
        var posRL = this.car.Wheel_RL.geometry.boundingSphere.center;
        this.car.Wheel_RL.setVisible(false);
        this.Wheel_RL = obj.clone();
        Common3D_set(this.Wheel_RL);
        this.Wheel_RL.enableShadowCast();
        this.car.add(this.Wheel_RL);
        this.Wheel_RL.setPosition(posRL);

        this.isReady = true;

        GAME.Tween.get(this).call(this.c, [this.car], this.cs);

        obj.setVisible(false);

    }, this);    
}

Smallthing.Car.prototype.destroy = function()
{

};

Smallthing.Car.prototype.moveTo = function(z, t, c, cs)
{
    if(this.isMove)
        return;

    this.isMove = true;

    if(rndInt(0, 100) > 50)
    {
        if(this.car.position.z < z)
            GAME.Tween.get(this).to({velocity:this.velocity+this.velocity*0.5}, 1000);
        else
            GAME.Tween.get(this).to({velocity:this.velocity-this.velocity*0.5}, 1000);

        this.car.createTweenAnimPosition().to({x:rndInt(-10, 10)/100, z:z/150}, t, GAME.Ease.cubicInOut).call(c, cs).call(function(){

            this.isMove = false;
        }, null, this);
    }
    else {

        if(this.car.position.z < z)
            GAME.Tween.get(this).to({velocity:this.velocity+this.velocity*0.5}, 1000);
        else
            GAME.Tween.get(this).to({velocity:this.velocity-this.velocity*0.5}, 1000);

        this.car.createTweenAnimPosition().to({x:rndInt(-10, 10)/100}, t, GAME.Ease.cubicInOut).call(c, cs).call(function(){

            this.isMove = false;
        }, null, this);
    }
};

Smallthing.Car.prototype.start = function(c, cs)
{
    this.isEnable = true;
    GAME.Tween.get(this).to({velocity:this.max_speed*0.3}, 3000).call(c, null, cs);

    this.timeToVibration = rndInt(10,20)/10;
    this.timeToVibrationWheel = rndInt(10,20)/10;
    this.timeToRandomX = rndInt(10,20)/10;

    this.soundSfxID = PRELOAD.get('Engine');
    if(this.soundSfxID != null) {
        this.soundSfxID.rate(0.9);
        this.soundSfxID.loop = true;
        this.soundSfxID.play();
    }
/*
    this.soundSfxID = playSfx('engineLoop');
    this.sfxRate = {rate:0};    
    GAME.Tween.get(this.sfxRate).to({rate:1.0}, 5000).call(c, null, cs);
*/    
};

Smallthing.Car.prototype.second = function(c, cs)
{
    this.isEnable = true;
    GAME.Tween.get(this).to({velocity:this.max_speed*0.6}, 3000).call(c, null, cs);
};

Smallthing.Car.prototype.fullspeed = function(c, cs)
{
    this.isEnable = true;
    GAME.Tween.get(this).to({velocity:this.max_speed*1.0}, 4000).call(c, null, cs);
};

Smallthing.Car.prototype.setPosition = function(position)
{
    if(!this.isReady)
        return;

    this.car.setPosition(position);

    if(this.LightLeft != null) this.LightLeft.position.set(this.car.position.x - 0.14, this.car.position.y + 0.11, this.car.position.z + 0.4);
    if(this.LightRight != null) this.LightRight.position.set(this.car.position.x + 0.14, this.car.position.y + 0.11, this.car.position.z + 0.4);
    if(this.LightLeft != null) this.LightLeft.target.position.set(this.car.position.x - 0.14, this.car.position.y + 0, this.car.position.z + 2.0);
    if(this.LightRight != null) this.LightRight.target.position.set(this.car.position.x + 0.14, this.car.position.y + 0, this.car.position.z + 2.0);
        
};

Smallthing.Car.prototype.setScale = function(scale)
{
    if(!this.isReady)
        return;

    this.car.setScale(scale);
};

Smallthing.Car.prototype.vibration = function()
{
    var k = 0.001;
    this.car.createTweenAnimPosition()
        .to({y:-1*k},100)
        .to({y:1*k},100)
        .to({y:-0.5*k},100)
        .to({y:0.5*k},100)
        .to({y:-0.25*k},100)
        .to({y:0.25*k},100)
        .to({y:-0.1*k},100)
        .to({y:0.1*k},100)
        .to({y:0},100).call(function(){

            var r = this.velocity / this.max_speed;

            if(r > 0.5)
                this.timeToVibration = (rndInt(10,20)/10)*0.5;
            else
                this.timeToVibration = (rndInt(10,20)/10);
                        
        }, null, this);
};

Smallthing.Car.prototype.vibrationWheel = function()
{
    var objects = [
        this.Wheel_FR,
        this.Wheel_FL,
        this.Wheel_RR,
        this.Wheel_RL
    ];

    var o = objects[rndInt(0,3)];
    
    var k = 0.001;
    o.createTweenAnimPosition()
        .to({y:-1*k},100)
        .to({y:1*k},100)
        .to({y:-0.5*k},100)
        .to({y:0.5*k},100)
        .to({y:-0.25*k},100)
        .to({y:0.25*k},100)
        .to({y:-0.1*k},100)
        .to({y:0.1*k},100)
        .to({y:0},100).call(function(){

            var r = this.velocity / this.max_speed;

            if(r > 0.5)
                this.timeToVibrationWheel = (rndInt(10,20)/10)*0.5;
            else
                this.timeToVibrationWheel = (rndInt(10,20)/10);
                        
        }, null, this);
};

Smallthing.Car.prototype.moveX = function()
{

};

Smallthing.Car.prototype.onUpdate = function(dtime)
{
    if(!this.isEnable)
        return;

    // apply cube map
    getManager3D().applyCubeMap(this.car.Body);

    this.velocity = this.speed * dtime;
    if(this.velocity > this.max_speed)
        this.velocity = this.max_speed;

    this.angle += this.velocity * dtime * this.kMult;

    if(this.Wheel_FR != null) this.Wheel_FR.setRotation(this.angle, 0, 0);
    if(this.Wheel_FL != null) this.Wheel_FL.setRotation(this.angle, 0, 0);
    if(this.Wheel_RR != null) this.Wheel_RR.setRotation(this.angle, 0, 0);
    if(this.Wheel_RL != null) this.Wheel_RL.setRotation(this.angle, 0, 0);

    if(this.timeToVibration >= 0)
    {
        this.timeToVibration -= dtime;
        if(this.timeToVibration < 0)
        {
            this.vibration();
        }
    }

    if(this.timeToVibrationWheel >= 0)
    {
        this.timeToVibrationWheel -= dtime;
        if(this.timeToVibrationWheel < 0)
        {
            this.vibrationWheel();
        }
    }

    if(this.timeToRandomX >= 0)
    {
        this.timeToRandomX -= dtime;
        if(this.timeToRandomX < 0)
        {
            this.timeToRandomX = rndInt(10,20)/10;
            
            this.moveX();
        }
    }    
};