/*
    author: Stefano Campodall'Orto
    copyright by Smallthing Studio 2018-2019 all right reserved.
*/
var Smallthing = Smallthing || {};


Smallthing.Preload = function()
{
    PRELOAD = this;

    if(OS_DEBUG)
    {
        FILES = Smallthing.FILES_DEBUG;
    }
    else 
    {
        
        FILES = Smallthing.FILES_RELEASE;
    }
    
    this.done = false;
    
    this.files = FILES;
    
    this.State = {
        
        kIdle : 0,
        kLoad : 1,
        kLoaded : 2
    }
    
    this.state = this.State.kLoad;
    
    this.index = 0;
}

Smallthing.Preload.prototype.constructor = Smallthing.Preload;

Smallthing.Preload.prototype.handleError = function (event) {
    
    console.warn('Error in SOUND loading');

    if(PRELOAD.index == PRELOAD.files.length)
    {
        PRELOAD.state = PRELOAD.State.kLoaded;
        PRELOAD.done = true;
        
        if(loadedGfx != null)
        {
            loadedGfx();
        }        
        return;
    }
    
    PRELOAD.state = PRELOAD.State.kLoad;
}

Smallthing.Preload.prototype.handleComplete = function (event) {

    //PRELOAD.index++;
    if(PRELOAD.index == PRELOAD.files.length)
    {
        PRELOAD.state = PRELOAD.State.kLoaded;
        PRELOAD.done = true;
        
        if(loadedGfx != null)
        {
            loadedGfx();
        }
        
        return;
    }
    
    PRELOAD.state = PRELOAD.State.kLoad;
}

Smallthing.Preload.prototype.get = function(id)
{
    if(id == null)
        return null;

    id = id.replace(".jpg", "");
    id = id.replace(".jpeg", "");
    id = id.replace(".png", "");

    for(var i = 0; i < this.files.length; i++)
    {
        if(this.files[i].id.toLowerCase() === id.toLowerCase()) {
            
            if(this.files[i].img != null)
                return this.files[i].img;

            if(this.files[i].mtl != null)
                return this.files[i];

            if(this.files[i].mdl != null)
                return this.files[i];

            if(this.files[i].fbx != null)
                return this.files[i];

            if(this.files[i].isGLB != null)
                return this.files[i].data;

            if(this.files[i].isGLTF != null)
                return this.files[i].data;

            if(this.files[i].json != null)
                return this.files[i].json;

            if(this.files[i].snd != null)
                return this.files[i].snd;
            
            return this.files[i].src;
        }
    }
    
    console.warn("*** Smallthing.Preload: cannot found " + id);
    
    return null;
}

Smallthing.Preload.prototype.onUpdate = function()
{
    switch(this.state)
    {
        case this.State.kIdle:
            break;
            
        case this.State.kLoad:
            
            for(var j = 0; j < 10; j++)
            {
                if(this.index < this.files.length)
                {
                    var file = this.files[this.index++];
                    if(file.isSound != null)
                    {
                        file.snd = new Howl({
                            src:[file.src],
                            preload:true,
                            loop:file.isLoop,
                            onload:this.handleComplete
                        });
                        
                        file.snd.src = file.src;
                        file.snd.onloadstart = this.handleComplete;
                    }
                    else if(file.isModel != null || file.isFBX != null)
                    {
                        file.fbx = {src:file.src};

                        if(this.index == this.files.length)
                        {
                            this.state = this.State.kLoaded;
                            this.done = true;
                            
                            if(loadedGfx != null)
                            {
                                loadedGfx();
                            }
                            
                            return;
                        }                        
                    } 
                    else if(file.isGLB != null || file.isGLTF != null)
                    {
                        file.data = {src:file.src};

                        if(this.index == this.files.length)
                        {
                            this.state = this.State.kLoaded;
                            this.done = true;
                            
                            if(loadedGfx != null)
                            {
                                loadedGfx();
                            }
                            
                            return;
                        }                        
                    }                     
                    else if(file.isJSON != null)
                    {
                        file.json = {src:file.src};

                        if(this.index == this.files.length)
                        {
                            this.state = this.State.kLoaded;
                            this.done = true;
                            
                            if(loadedGfx != null)
                            {
                                loadedGfx();
                            }
                            
                            return;
                        }                         
                    }
                    else if(file.isMaterial != null)
                    {
                        file.mtl = {src:file.src};

                        if(this.index == this.files.length)
                        {
                            this.state = this.State.kLoaded;
                            this.done = true;
                            
                            if(loadedGfx != null)
                            {
                                loadedGfx();
                            }
                            
                            return;
                        }                        
                    }                    
                    else 
                    {
                        if(file.noPreload != null)
                        {
                            if(this.index == this.files.length)
                            {
                                this.state = this.State.kLoaded;
                                this.done = true;
                                
                                if(loadedGfx != null)
                                {
                                    loadedGfx();
                                }
                            }                             
                        }
                        else {

                            file.img = new Image();
                            file.img.src = file.src;
                            file.img.onload = this.handleComplete;  
                            file.img.onerror = function(t)
                            {
                                console.error('gfx error:', t.target.currentSrc);
                            }            
                        }
                    }
                }
            }
            
            break;
            
        case this.State.kLoaded:
            
            break;
    }
}