var Smallthing = Smallthing || {};

Smallthing.ObjectManager = function()
{
    OBJECTMANAGER = this;

    getObjectManager = function()
    {
        return OBJECTMANAGER;
    }   
}

Smallthing.ObjectManager.prototype.constructor = Smallthing.ObjectManager;

/* create stati elemnets */
Smallthing.ObjectManager.id = 0;

Smallthing.ObjectManager.objects = new Array();

Smallthing.ObjectManager.prototype.push = function(object)
{
    if(this.findObjectByUUID(object) === true)
        return;
    
    Smallthing.ObjectManager.id++;
    object.__object_id = Smallthing.ObjectManager.id;
    Smallthing.ObjectManager.objects.push(object);
}

Smallthing.ObjectManager.prototype.remove = function(object)
{
    for(var i = 0; i < Smallthing.ObjectManager.objects.length; ++i)
    {
        if(Smallthing.ObjectManager.objects[i].__object_id == object.__object_id) {
            
            Smallthing.ObjectManager.objects.splice(i, 1);

            console.log()

            return true;
        }            
    }
    
    return false;
}

Smallthing.ObjectManager.prototype.onMouseDown = function(evt)
{
    var j = 0;
    try {
        
        for(j = 0; j < Smallthing.ObjectManager.objects.length; j++)
        {
            var o = Smallthing.ObjectManager.objects[j];
            if(o.onMouseDown != null)
                o.onMouseDown(evt);
        }
    }
    catch(e) {
        console.warn('Error onMouseDown in ' + Smallthing.ObjectManager.objects[j]);
    }
}

Smallthing.ObjectManager.prototype.onMouseUp = function(evt)
{
    for(var j = 0; j < Smallthing.ObjectManager.objects.length; j++)
    {
        var o = Smallthing.ObjectManager.objects[j];
        if(o.onMouseUp != null)
            o.onMouseUp(evt);
    }
}

Smallthing.ObjectManager.prototype.onMouseMove = function(evt)
{
    for(var j = 0; j < Smallthing.ObjectManager.objects.length; j++)
    {
        var o = Smallthing.ObjectManager.objects[j];
        if(o.onMouseMove != null)
            o.onMouseMove(evt);
    }
}

Smallthing.ObjectManager.prototype.asDirty = function()
{
    for(var i = 0; i < Smallthing.ObjectManager.objects.length; ++i) {
        
        var o = Smallthing.ObjectManager.objects[i];
        o.dirty = true;
    }
}

Smallthing.ObjectManager.prototype.getObjectByName = function(name)
{
    for(var i = 0; i < Smallthing.ObjectManager.objects.length; ++i) {
        
        var o = Smallthing.ObjectManager.objects[i];
        if(o.name === name)
            return o;
    }    
    return null;
}

Smallthing.ObjectManager.prototype.findObjectByUUID = function(o)
{
    var uuid = o.uuid;
    if(uuid == null)
        return -1;

    for(var i = 0; i < Smallthing.ObjectManager.objects.length; ++i) {
        
        var obj = Smallthing.ObjectManager.objects[i];
        if(obj.uuid === o.uuid)
        {
            return true;
        }
    }    

    return false;
}

Smallthing.ObjectManager.prototype.onUpdate = function(dtime)
{
    for(var i = 0; i < Smallthing.ObjectManager.objects.length; ++i) {
        
        var o = Smallthing.ObjectManager.objects[i];
        
        if(o != null) {

            try {

                if(o.getVisible() == false)
                    continue;

                if(o.onUpdate != null)
                {
                    o.onUpdate(dtime);
                }
            }
            catch(e) {
                
                console.warn('Error in Smallthing.ObjectManager: ' + o.__internal_id + ' ' + e);
            }
        }
        
    }
}

Smallthing.ObjectManager.TypeSprite = 1;
Smallthing.ObjectManager.TypeText = 2;