var Smallthing = Smallthing || {};

Smallthing.GameState = {

    init: function () {

        GAMESTATE = this;
        
        this.currentScene = null;
        
        this.scale = playable.scale();
		
        OS_GAME_SCALE = playable.scale();
        
        console.log("*** GAME SCALE: " + OS_GAME_SCALE);
        
        this.State = {
            kIdle : 0,
            kSetScene : 1,
            kNextScene : 2,
            kUpdateScene : 3
        }
        
        this.state = this.State.kIdle;
    },

    create: function () {

        console.log("game.create");

        playable.ready();
        
        this.gameData = new Smallthing.GameData(this.game);
        
		this.gameOver = null;        
    },

    startGame: function (parent) {

        this.started = true;
        
        this.currentTime = this.TIMER_TIME + 1;
        this.progressBarTimer = this.TIMER_TIME;

        if(!playable.counterStarted) {
            
            playable.counterStarted = true;            
        }
    },
    
    gameFinished: function() {
        
		if(this.timer != null) {
			
			this.GameOver();
			this.ui.destroy();
		}
    },
        
    GameOver: function () {
        
        this.gameOver = new Smallthing.GameOver(this.game);
    },

    SetNextScene: function(scene)
    {
        this.nextScene = scene;
        this.state = this.State.kSetScene;
    },
    
	update: function(dtime) {

        OS_GAME_SCALE = playable.scale();
        
        if(this.gameOver != null)
            this.gameOver.onUpdate(dtime);
        
        switch(this.state)
        {
            case this.State.kIdle:
                break;
                
            case this.State.kSetScene:
    
                if(this.currentScene != null)
                    this.currentScene.finalize();
    
                this.state = this.State.kNextScene;
    
                break;
                
            case this.State.kNextScene:
    
                if(this.nextScene == null)
                    console.error("*** Missing scene ***");
    
                this.currentScene = this.nextScene;
                this.currentScene.initialize();
                this.nextScene = null;
    
                this.state = this.State.kUpdateScene;
    
                break;
            
            case this.State.kUpdateScene:
    
                this.currentScene.update(dtime);
    
                break;
        }
	},
};
