	if ( ! Detector.webgl ) Detector.addGetWebGLMessage();


	var container, stats, controls;
	var camera, scene, renderer, light;
	var clock = new THREE.Clock();
	var mixers = [];

	init();
	animate();

	//Animations
	var animations;
	var idle, hello;

	function init() {
		container = document.createElement( 'div' );
		document.body.appendChild( container );
		camera = new THREE.PerspectiveCamera( 45, window.innerWidth / window.innerHeight, 1, 10000 );
		camera.position.set( 100, 1400, 1200 );
		controls = new THREE.OrbitControls( camera );
		controls.target.set( 0, 100, 0 );
		controls.update();
		scene = new THREE.Scene();
		scene.background = new THREE.Color( 0xa0a0a0 );
		light = new THREE.HemisphereLight( 0xffffff, 0x444444 );
		light.position.set( 0, 200, 0 );
		scene.add( light );
		light = new THREE.DirectionalLight( 0xffffff );
		light.position.set( 0, 200, 100 );
		light.castShadow = true;
		scene.add( light );
		// scene.add( new THREE.CameraHelper( light.shadow.camera ) );
		// ground
		var mesh = new THREE.Mesh( new THREE.PlaneBufferGeometry( 2000, 2000 ), new THREE.MeshPhongMaterial( { color: 0x999999, depthWrite: false } ) );
		mesh.rotation.x = - Math.PI / 2;
		mesh.receiveShadow = true;
		scene.add( mesh );
		var grid = new THREE.GridHelper( 2000, 20, 0x000000, 0x000000 );
		grid.material.opacity = 0.2;
		grid.material.transparent = true;
		scene.add( grid );
		// model
		var loader = new THREE.FBXLoader();
		
		loader.load( 'assets/models/mari/Mari.fbx', function ( object ) {
			
			object.mixer = new THREE.AnimationMixer( object );
			mixers.push( object.mixer );
			animations = object.animations;
			
			hello = object.mixer.clipAction( object.animations[ 0 ] );
			window.hello = hello;
			idle = object.mixer.clipAction( object.animations[ 1 ] );
			window.idle = idle;

			hello.play();
			window.mixer = object.mixer;
			object.traverse( function ( child ) {
				
				if ( child.isMesh ) {
					window.child = child;
					var texLoader = new THREE.TextureLoader();
					texLoader.load("assets/models/mari/mari.png", function(tex){
						child.material.map = tex;
						child.material.needsUpdate = true;
					});
					
					child.castShadow = true;
					child.receiveShadow = true;
				}
			} );
			scene.add( object );
		});
		renderer = new THREE.WebGLRenderer( { antialias: true } );
		renderer.setPixelRatio( window.devicePixelRatio );
		renderer.setSize( window.innerWidth, window.innerHeight );
		renderer.shadowMap.enabled = true;
		container.appendChild( renderer.domElement );
		window.addEventListener( 'resize', onWindowResize, false );
		// stats
		stats = new Stats();
		container.appendChild( stats.dom );


		document.addEventListener("keydown", onDocumentKeyDown, false);
		


	}
	function play(name,loop){

		 var to = mesh.animations[ name ];		

		  if( mesh.currentAnimation ){

		    var from = animations[ mesh.currentAnimation ];

		    //from.setEffectiveWeight( 1 );
		    //to.setEffectiveWeight( 1 );

		    if( loop ){

		      to.setLoop(THREE.LoopRepeat);
		      to.clampWhenFinished = false;

		    }else{

		      to.setLoop(THREE.LoopOnce, 0);
		      to.clampWhenFinished = true;					

		      mesh.mixer.addEventListener('finished',function(e){

		        play('Idle',true);

		      });						

		    }

		    from.play();
		    to.play();

		    from.enabled = true;
		    to.enabled = true;

		    from.crossFadeTo( to, 0.3, true);					

		  }else{

		    to.play();

		  }

		  mesh.currentAnimation = name;

		}
	function onDocumentKeyDown(event) {
	    var keyCode = event.which;
	    if (keyCode == 87) {

	    	hello.play();
	    	idle.play();

	    	hello.enabled = true;
	    	idle.enabled = true;

	        hello.crossFadeTo(idle, 0.3);
	    } 
	}

	function onWindowResize() {
		camera.aspect = window.innerWidth / window.innerHeight;
		camera.updateProjectionMatrix();
		renderer.setSize( window.innerWidth, window.innerHeight );
	}
	//
	function animate() {
		requestAnimationFrame( animate );
		if ( mixers.length > 0 ) {
			for ( var i = 0; i < mixers.length; i ++ ) {
				mixers[ i ].update( clock.getDelta() );
			}
		}
		renderer.render( scene, camera );
		stats.update();
	}