from network import LoRa
import socket
import utime
import binascii
import pycom
import ustruct
import machine
from machine import ADC

from machine import RTC
from machine import SD
import os


# takes battery voltage readings
def adc_battery():

	adc = ADC(0)                                        # initialise adc hardware
	adc_c = adc.channel(attn=3, pin='P16')              # create an object to sample ADC on pin 16 with attenuation of 11db (config 3)
	adc_samples = []                                    # initialise the list
	for count in range(100):                            # take 100 samples and append them into the list
		adc_samples.append(int(adc_c()))

	adc_samples = sorted(adc_samples)                   # sort the list
	adc_median = adc_samples[int(len(adc_samples)/2)]   # take the center list row value (median average)
	# apply the function to scale to volts
##	adc_median = adc_median * 2 / 4095 / 0.3275
	print(adc_samples)

	return adc_median

# disable LED heartbeat (so we can control the LED)
pycom.heartbeat(False)
# set LED to red
pycom.rgbled(0x7f0000)

# lora config
lora = LoRa(mode=LoRa.LORAWAN, region=LoRa.AS923)
# access info
app_eui = binascii.unhexlify('70B3D57ED0017190')
app_key = binascii.unhexlify('32315ED53FFB6664069EFB364CFAE9B4')

# attempt join - continues attempts background
lora.join(activation=LoRa.OTAA, auth=(app_eui, app_key), timeout=0)

# wait for a connection
print('Waiting for LoRaWAN network connection...')
while not lora.has_joined():
	utime.sleep(1)
	# if no connection in a few seconds, then reboot
	if utime.time() > 15:
		print("possible timeout")
		machine.reset()
	pass

# we're online, set LED to green and notify via print
pycom.rgbled(0x007f00)
print('Network joined!')

# setup the socket
s = socket.socket(socket.AF_LORA, socket.SOCK_RAW)
s.setsockopt(socket.SOL_LORA, socket.SO_DR, 5)
s.setblocking(False)
s.bind(1)

# open the RTC
rtc = RTC()
now = rtc.now()

# open the SD Card
sd = SD()
os.mount(sd, '/sd')
#f = open('/sd/batlog%d/%02d/%02d %02d:%02d:%02d.txt' % (now[0], now[1],now[2], now[3], now[4], now[5]), 'a+')

count = 0
# limit to 200 packets; just in case power is left on 20000 x 10 sec = 55h
while count <= 20000:
	lipo_voltage = adc_battery()

	f = open('/sd/batlog2.txt','a+')
	now = rtc.now()

	print("%d/%02d/%02d %02d:%02d:%02d count=%05d Battery_voltage: %d" % (now[0], now[1],now[2], now[3], now[4], now[5], count, lipo_voltage))
	# encode the packet, so that it's in BYTES (TTN friendly)
	# could be extended like this struct.pack('f',lipo_voltage) + struct.pack('c',"example text")
	packet = ustruct.pack('h',lipo_voltage)
	f.write("%d/%02d/%02d %02d:%02d:%02d count=%05d Battery_voltage: %d" % (now[0], now[1],now[2], now[3], now[4], now[5], count, lipo_voltage))

	# example of unpacking a payload - unpack returns a sequence of
	#immutable objects (a list) and in this case the first object is the only object

	if (count%10) == 0:
		s.send(packet)
		print ("Sent value is:", ustruct.unpack('h',packet)[0])
		f.write(" Sent")
		pycom.rgbled(0x7f0000) #red
	else:
		pycom.rgbled(0x7f7f00) #yellow

	f.write("\r\n")
	count += 1
	f.close()
	
	utime.sleep(1)
	pycom.rgbled(0x007f00) #green
	utime.sleep(9)
